function [y,b,a]=schroeder2(x,cg,cd,ag,ad,k)

%This is a reverberator based on Schroeder's design which consists of 4 parallel feedback comb filters 
%in series with 2 cascaded all pass filters.
%
%The structure is:  [y,b,a] = schroeder2(x,cg,cd,ag,ad,k)
%
%where x = the input signal
%      cg = a vector of length 4 which contains the gain of each of the comb filters (should be less than 1 for stability)	
%      cd = a vector of length 4 which contains the delay of each of the comb filters 
%      ag = the gain of the allpass filters (this should be less than 1 for stability)
%      ad = a vector of length 2 which contains the delay of each of the allpass filters 
%      k = the gain factor of the direct signal
%      y = the output signal
%      b = the numerator coefficients of the transfer function
%      a = the denominator coefficients of the transfer function
%
%
% Gautham J. Mysore - gauthamjm@yahoo.com
%



% send the input to each of the 4 comb filters separately
[outcomb1,b1,a1] = fbcomb(x,cg(1),cd(1));
[outcomb2,b2,a2] = fbcomb(x,cg(2),cd(2));
[outcomb3,b3,a3] = fbcomb(x,cg(3),cd(3));
[outcomb4,b4,a4] = fbcomb(x,cg(4),cd(4));

% sum the ouptut of the 4 comb filters
apinput = outcomb1 + outcomb2 + outcomb3 + outcomb4; 

%find the combined filter coefficients of the the comb filters
[b,a]=parallelcoefficients(b1,a1,b2,a2);
[b,a]=parallelcoefficients(b,a,b3,a3);
[b,a]=parallelcoefficients(b,a,b4,a4);

% send the output of the comb filters to the allpass filters
[y,b5,a5] = allpass(apinput,ag,ad(1));
[y,b6,a6] = allpass(y,ag,ad(2));

%find the combined filter coefficients of the the comb filters in series with the allpass filters
[b,a]=seriescoefficients(b,a,b5,a5);
[b,a]=seriescoefficients(b,a,b6,a6);

% add the scaled direct signal
y = y + k*x;

% normalize the output signal
y = y/max(y);
